/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.sniffer;

import jade.gui.AclGui;
import jade.lang.acl.ACLMessage;
import jade.tools.sniffer.Agent;
import jade.tools.sniffer.AgentList;
import jade.tools.sniffer.MainPanel;
import jade.tools.sniffer.MainWindow;
import jade.tools.sniffer.Message;
import jade.tools.sniffer.MessageList;
import jade.tools.sniffer.PanelCanvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class MMCanvas
extends JPanel
implements MouseListener,
MouseMotionListener,
Serializable {
    private static final int V_TOL = 4;
    private static final int H_TOL = 4;
    private static final int timeUnitWidth = 20;
    private static final int xOffset = 38;
    private int positionAgent = 0;
    private int x1;
    private int x2;
    private int y;
    private MainWindow mWnd;
    private PanelCanvas panCan;
    private MainPanel mPan;
    private int horDim = 400;
    private int vertDim = 200;
    private boolean typeCanv;
    private boolean nameShown = false;
    private List noSniffAgents = new ArrayList();
    private Font font1 = new Font("Helvetica", 2, 12);
    private Font font2 = new Font("SanSerif", 1, 12);
    private Font font3 = new Font("SanSerif", 0, 10);
    private MMCanvas otherCanv;
    public AgentList al;
    public MessageList ml;
    private HashMap mapToColor = new HashMap();
    private Color[] colorTable = new Color[]{Color.blue, Color.black, Color.cyan, Color.magenta, Color.red, Color.white, Color.yellow};
    private Integer colorCounter = new Integer(-1);

    public MMCanvas(boolean type, MainWindow mWnd, PanelCanvas panCan, MainPanel mPan, MMCanvas other) {
        this.otherCanv = other;
        this.typeCanv = type;
        this.al = new AgentList();
        this.ml = new MessageList();
        this.panCan = panCan;
        this.setDoubleBuffered(false);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.mWnd = mWnd;
        this.mPan = mPan;
        if (this.typeCanv) {
            this.setPreferredSize(new Dimension(this.horDim, 50));
        } else {
            this.setPreferredSize(new Dimension(this.horDim, this.vertDim));
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int yDim = 0;
        int xSource = 0;
        int xDest = 0;
        int xCanvDim = 0;
        try {
            if (this.typeCanv) {
                Iterator it = this.al.getAgents();
                while (it.hasNext()) {
                    String part3;
                    String part2;
                    String part1;
                    Agent agent = (Agent)it.next();
                    int x = 20 + xCanvDim++ * 80;
                    if (!agent.onCanv) {
                        g.setColor(Color.gray);
                    } else {
                        g.setColor(Color.red);
                    }
                    if (this.checkNoSniffedVector(agent)) {
                        g.setColor(Color.yellow);
                    }
                    g.draw3DRect(x, 20, 50, 30, true);
                    g.fill3DRect(x, 20, 50, 30, true);
                    g.setColor(Color.black);
                    FontMetrics fm = g.getFontMetrics();
                    String aName = agent.agentName;
                    aName = this.nameClip(aName);
                    int nameWidth = fm.stringWidth(aName);
                    if (nameWidth < 50) {
                        g.drawString(aName, x + (50 - nameWidth) / 2, 35 + fm.getAscent() / 2);
                        continue;
                    }
                    int len = aName.length();
                    if (nameWidth < 100) {
                        part1 = aName.substring(0, len / 2);
                        part2 = aName.substring(len / 2);
                        g.drawString(part1, x + (50 - fm.stringWidth(part1)) / 2, 35 - (int)((double)fm.getAscent() * 0.2));
                        g.drawString(part2, x + (50 - fm.stringWidth(part2)) / 2, 35 + (int)((double)fm.getAscent() * 0.9));
                        continue;
                    }
                    if (nameWidth < 150) {
                        part1 = aName.substring(0, len / 3);
                        part2 = aName.substring(len / 3, 2 * len / 3);
                        part3 = aName.substring(2 * len / 3);
                        g.drawString(part1, x + (50 - fm.stringWidth(part1)) / 2, 35 - (int)((double)fm.getAscent() * 0.65));
                        g.drawString(part2, x + (50 - fm.stringWidth(part2)) / 2, 35 + (int)((double)fm.getAscent() * 0.3));
                        g.drawString(part3, x + (50 - fm.stringWidth(part3)) / 2, 35 + (int)((double)fm.getAscent() * 0.95));
                        continue;
                    }
                    int approxCharWidth = nameWidth / agent.agentName.length();
                    int charCount = 50 / approxCharWidth;
                    part1 = aName.substring(0, charCount);
                    if (aName.length() < charCount * 2) {
                        part2 = aName.substring(charCount);
                        part3 = "";
                    } else {
                        part2 = aName.substring(charCount, charCount * 2);
                        part3 = charCount * 3 > aName.length() ? aName.substring(charCount * 2) : aName.substring(charCount * 2, charCount * 3);
                    }
                    g.drawString(part1, x + (50 - fm.stringWidth(part1)) / 2, 35 - (int)((double)fm.getAscent() * 0.65));
                    g.drawString(part2, x + (50 - fm.stringWidth(part2)) / 2, 35 + (int)((double)fm.getAscent() * 0.3));
                    g.drawString(part3, x + (50 - fm.stringWidth(part3)) / 2, 35 + (int)((double)fm.getAscent() * 0.95));
                }
                this.horDim = 100 + xCanvDim * 80;
            }
            if (!this.typeCanv) {
                int[] xCoords = new int[3];
                int[] yCoords = new int[3];
                xCanvDim = this.otherCanv.al.size();
                Iterator it = this.ml.getMessages();
                int AllReceiver = 0;
                while (it.hasNext()) {
                    Message mess = (Message)it.next();
                    String senderName = mess.getSender().getName();
                    xSource = this.otherCanv.al.getPos(senderName);
                    String receiverName = mess.getUnicastReceiver().getName();
                    xDest = this.otherCanv.al.getPos(receiverName);
                    int x1 = mess.getInitSeg(xSource);
                    int x2 = mess.getEndSeg(xDest);
                    int y = mess.getOrdSeg(yDim++);
                    xCoords[0] = x2 - 6;
                    xCoords[1] = x2 - 6;
                    xCoords[2] = x2 + 2;
                    yCoords[0] = y - 5;
                    yCoords[1] = y + 5;
                    yCoords[2] = y;
                    if (x1 > x2) {
                        xCoords[0] = x2 + 10;
                        xCoords[1] = x2 + 10;
                        xCoords[2] = x2 + 2;
                    }
                    Integer colorIndex = new Integer(-1);
                    if (mess.getConversationId() != null && this.mapToColor.containsKey(mess.getConversationId())) {
                        colorIndex = (Integer)this.mapToColor.get(mess.getConversationId());
                    }
                    if (mess.getReplyWith() != null && colorIndex == -1 && this.mapToColor.containsKey(mess.getReplyWith())) {
                        colorIndex = (Integer)this.mapToColor.get(mess.getReplyWith());
                    }
                    if (mess.getInReplyTo() != null && colorIndex == -1 && this.mapToColor.containsKey(mess.getInReplyTo())) {
                        colorIndex = (Integer)this.mapToColor.get(mess.getInReplyTo());
                    }
                    if (colorIndex == -1) {
                        colorIndex = this.colorCounter = new Integer(this.colorCounter + 1);
                    }
                    if (mess.getConversationId() != null) {
                        this.mapToColor.put(mess.getConversationId(), colorIndex);
                    }
                    if (mess.getReplyWith() != null) {
                        this.mapToColor.put(mess.getReplyWith(), colorIndex);
                    }
                    if (mess.getInReplyTo() != null) {
                        this.mapToColor.put(mess.getInReplyTo(), colorIndex);
                    }
                    g.setColor(this.colorTable[colorIndex % this.colorTable.length]);
                    g.drawRect(x1 - 3, y - 4, 4, 8);
                    g.fillRect(x1 - 3, y - 4, 4, 8);
                    g.setFont(this.font3);
                    FontMetrics fmPerf = g.getFontMetrics();
                    String perf = Message.getPerformative(mess.getPerformative());
                    int numberToShow = 3;
                    perf = perf + ":" + colorIndex + " (" + this.tail(numberToShow, mess.getConversationId()) + "  " + this.tail(numberToShow, mess.getReplyWith()) + "  " + this.tail(numberToShow, mess.getInReplyTo()) + " )";
                    int perfWidth = fmPerf.stringWidth(perf);
                    if (x2 > x1) {
                        g.drawString(perf, x1 + (x2 - x1) / 2 - perfWidth / 2, y - 4);
                    } else {
                        g.drawString(perf, x2 + (x1 - x2) / 2 - perfWidth / 2, y - 4);
                    }
                    int k = -1;
                    while (k <= 1) {
                        if (x2 > x1) {
                            g.drawLine(x1, y + k, x2, y + k);
                        } else {
                            g.drawLine(x1, y + k, x2 + 4, y + k);
                        }
                        ++k;
                    }
                    g.drawPolygon(xCoords, yCoords, 3);
                    g.fillPolygon(xCoords, yCoords, 3);
                    ++AllReceiver;
                }
                int msgNum = this.ml.size();
                int num = 0;
                while (num < xCanvDim) {
                    int x = 10 + num * 80;
                    g.setColor(new Color(0, 100, 50));
                    int counter = 0;
                    Iterator i = this.ml.getMessages();
                    while (i.hasNext()) {
                        Message msg = (Message)i.next();
                        msg.setMessageNumber(counter++);
                    }
                    g.drawLine(x + 38, 1, x + 38, 20 * (counter + 1));
                    ++num;
                }
                g.setColor(new Color(150, 50, 50));
                int t = 0;
                while (t <= AllReceiver) {
                    Integer msgNumWrapped = new Integer(t);
                    g.drawString(msgNumWrapped.toString(), 10, 20 * t + 15);
                    ++t;
                }
                this.horDim = 100 + xCanvDim * 80;
                this.vertDim = 100 + yDim * 20;
            }
        }
        catch (ConcurrentModificationException cme) {}
    }

    public void mousePressed(MouseEvent evt) {
        String info = "";
        int numberToShow = 5;
        Message mess = this.selMessage(evt);
        if (mess != null && !this.typeCanv) {
            info = "  Message:" + mess.getMessageNumber() + " ";
            this.mPan.textArea.setText(" ");
            this.mPan.textArea.setText(info);
            this.mPan.textArea.setFont(this.font2);
            this.mPan.textArea.append(ACLMessage.getPerformative(mess.getPerformative()) + " ( cid=" + this.tail(numberToShow, mess.getConversationId()) + " rw=" + this.tail(numberToShow, mess.getReplyWith()) + " irt=" + this.tail(numberToShow, mess.getInReplyTo()) + " proto=" + mess.getProtocol() + " onto=" + mess.getOntology() + " )");
        } else {
            Agent selectedAgent = this.selAgent(evt);
            if (selectedAgent != null && this.typeCanv) {
                this.mPan.textArea.setText("Agent: ");
                this.mPan.textArea.setFont(this.font2);
                this.mPan.textArea.append(selectedAgent.agentName);
            }
        }
    }

    public void mouseClicked(MouseEvent evt) {
        Message mess;
        if (evt.getClickCount() == 2 && (mess = this.selMessage(evt)) != null && !this.typeCanv) {
            AclGui.showMsgInDialog(mess, this.mWnd);
        }
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void mouseDragged(MouseEvent evt) {
    }

    public void mouseMoved(MouseEvent evt) {
        Agent selectedAgent = this.selAgent(evt);
        if (selectedAgent != null && this.typeCanv) {
            if (!this.nameShown) {
                this.nameShown = true;
                this.mPan.textArea.setText("Agent: ");
                this.mPan.textArea.setFont(this.font2);
                this.mPan.textArea.append(selectedAgent.agentName);
            }
        } else if (this.nameShown) {
            this.nameShown = false;
            this.mPan.textArea.setText(null);
        }
    }

    private boolean checkNoSniffedVector(Agent agent) {
        boolean isPresent = false;
        if (this.noSniffAgents.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < this.noSniffAgents.size()) {
            Agent agentToCompare = (Agent)this.noSniffAgents.get(i);
            if (agentToCompare.agentName.equals(agent.agentName)) {
                isPresent = true;
                this.positionAgent = i;
                break;
            }
            ++i;
        }
        return isPresent;
    }

    public Message selMessage(MouseEvent evt) {
        int j = 0;
        Iterator it = this.ml.getMessages();
        while (it.hasNext()) {
            Message mess = (Message)it.next();
            String senderName = mess.getSender().getName();
            String receiverName = mess.getUnicastReceiver().getName();
            this.x1 = mess.getInitSeg(this.otherCanv.al.getPos(senderName));
            this.x2 = mess.getEndSeg(this.otherCanv.al.getPos(receiverName));
            this.y = mess.getOrdSeg(j++);
            if (!(this.x1 < this.x2 ? evt.getX() >= this.x1 + 4 && evt.getX() <= this.x2 + 4 && evt.getY() >= this.y - 4 && evt.getY() <= this.y + 4 : evt.getX() >= this.x2 - 4 && evt.getX() <= this.x1 + 4 && evt.getY() >= this.y - 4 && evt.getY() <= this.y + 4)) continue;
            return mess;
        }
        return null;
    }

    public Agent selAgent(MouseEvent evt) {
        int j = 0;
        int y1 = 20;
        int y2 = y1 + 20;
        try {
            Iterator it = this.al.getAgents();
            while (it.hasNext()) {
                Agent ag = (Agent)it.next();
                this.x1 = 20 + j * 80;
                this.x2 = this.x1 + 50;
                if (evt.getX() >= this.x1 && evt.getX() <= this.x2 && evt.getY() >= y1 && evt.getY() <= y2) {
                    if (ag.agentName.equals("Other")) {
                        return null;
                    }
                    return ag;
                }
                ++j;
            }
        }
        catch (ConcurrentModificationException cme) {}
        return null;
    }

    private void repaintBothCanvas() {
        MMCanvas c1 = this.panCan.canvAgent;
        MMCanvas c2 = this.panCan.canvMess;
        this.panCan.setPreferredSize(new Dimension(this.horDim, this.vertDim + 50));
        c1.setPreferredSize(new Dimension(this.horDim, 50));
        c2.setPreferredSize(new Dimension(this.horDim, this.vertDim));
        this.panCan.revalidate();
        c1.repaint();
        c2.repaint();
    }

    public void rAgfromNoSniffVector(Agent agent) {
        if (this.checkNoSniffedVector(agent)) {
            this.noSniffAgents.remove(this.positionAgent);
            this.repaintBothCanvas();
        }
    }

    public void addAgent(Agent agent) {
        this.al.addAgent(agent);
        this.repaintBothCanvas();
    }

    public void removeAgent(String agentName) {
        try {
            this.al.removeAgent(agentName);
            this.repaintBothCanvas();
        }
        catch (Exception e) {}
    }

    public void removeAllAgents() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MMCanvas.this.al.removeAllAgents();
                MMCanvas.this.ml.removeAllMessages();
                MMCanvas.this.repaintBothCanvas();
            }
        });
    }

    public void repaintNoSniffedAgent(Agent agent) {
        if (!this.checkNoSniffedVector(agent)) {
            this.noSniffAgents.add(agent);
        }
        this.repaintBothCanvas();
    }

    public void addMessage(final Message mess) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MMCanvas.this.ml.addMessage(mess);
                MMCanvas.this.repaintBothCanvas();
            }
        });
    }

    public void removeAllMessages() {
        try {
            this.ml.removeAllMessages();
            this.repaintBothCanvas();
        }
        catch (Exception e) {}
    }

    public boolean isPresent(String agName) {
        return this.al.isPresent(agName);
    }

    public AgentList getAgentList() {
        return this.al;
    }

    public MessageList getMessageList() {
        return this.ml;
    }

    public void setAgentList(AgentList savedList) {
        this.al = savedList;
        this.repaintBothCanvas();
    }

    public void setMessageList(MessageList savedList) {
        this.ml = savedList;
        this.repaintBothCanvas();
    }

    public void recMessage(Message newMess) {
        this.addMessage(newMess);
    }

    private String tail(int n, String s) {
        try {
            return s.substring(s.length() - n, s.length());
        }
        catch (Exception any) {
            return " ";
        }
    }

    private String nameClip(String aName) {
        String clipNames = this.mWnd.getProperties().getProperty("clip", null);
        if (clipNames == null) {
            return aName;
        }
        StringTokenizer parser = new StringTokenizer(clipNames, ";");
        while (parser.hasMoreElements()) {
            String clip = parser.nextToken();
            if (!aName.startsWith(clip)) continue;
            return aName.substring(clip.length());
        }
        return aName;
    }
}

